; Bless - Default Example.bb
; An example of how to use BLESS with the default event notification method.
; (i.e. UseAlternateMethod(False))
;
; Suitable for BlitzPlus, though some things can be applied to Blitz3D.

Include "bless.bb" ; Required

Global w, cb, tv, eb, lb, hwnd, nid, b1, b2, b3, chk1, chk2, tar ; Mostly GUI stuff

; Initialize window and stuff
InitGui()
CreateTimer(60) ; To force message pump to keep reading events, even when out of focus

; For Drag-and-drop (see MSDN)
Bless_DragAcceptFiles(hwnd, True)

; Register the Windows events and windows we want to pay attention to
Bless_RegisterEvent(BLESS, WM_COMMAND, hwnd, hwnd)
Bless_RegisterEvent(BLESS+1, WM_NOTIFY, hwnd, hwnd)
Bless_RegisterEvent(BLESS+2, WM_CUT, QueryObject(eb,1), hwnd)
Bless_RegisterEvent(BLESS+3, WM_COPY, QueryObject(eb,1), hwnd)
Bless_RegisterEvent(BLESS+4, WM_PASTE, QueryObject(eb,1), hwnd)
Bless_RegisterEvent(BLESS+5, WM_LBUTTONDOWN, hwnd, hwnd)
Bless_RegisterEvent(BLESS+6, WM_RBUTTONDOWN, hwnd, hwnd)
Bless_RegisterEvent(BLESS+7, WM_DROPFILES, hwnd, hwnd)
Bless_RegisterEvent(BLESS+8, WM_USER, hwnd, hwnd)
Bless_RegisterEvent(BLESS+9, WM_DRAWITEM, hwnd, hwnd)

Repeat
	Select WaitEvent()
		Case $803 ; End
			Bless_UnregisterEvent(0) ; Highly recommended to unregister all BLESS events
			End
		Case $103
			If EventData() >= BLESS And EventData() <= BLESSMAX Then HandleBlessEvent(EventData())
			; else handle standard keychar event
		Case $401
			Select EventSource()
				Case b1 ; Minimize to Tray
					; Hide window
					Bless_GetWindowPlacement(hwnd, Bless_WP)
					Bless_WP\showcmd = 0
					Bless_SetWindowPlacement(hwnd, Bless_WP)
					; Set tray icon
					Shell_NotifyIcon(0, nid)
				Case b2 ; Custom (OwnerDraw) Button
					TextOut("You clicked the Custom Button")
				Case b3 ; Notepad Demo
					If ExecFile("notepad.exe")
						Delay 100
						NotepadDemo()
					EndIf
				Case chk1
					If ButtonState(chk1)
						Bless_RegisterEvent(BLESS+50, WM_MOUSEMOVE, hwnd, hwnd)
					Else
						Bless_UnregisterEvent(BLESS+50)
					EndIf
				Case chk2
					If ButtonState(chk2)
						Bless_RegisterEvent(BLESS+51, WM_MOUSEMOVE, QueryObject(tar,1), hwnd)
					Else
						Bless_UnregisterEvent(BLESS+51)
					EndIf
			End Select
	End Select
Forever

Function HandleBlessEvent(id)
	Bless_EventData(id, Bless_EventData)
	Select EventData()
		Case BLESS ; WM_COMMAND
			Select Bless_EventData\lparam
				Case QueryObject(cb,1) ; Combobox command message
					Select (Bless_EventData\wparam Shr 16)
						Case CBN_SELCHANGE : TextOut("Combobox: Selection change occurred")
						Case CBN_KILLFOCUS : TextOut("Combobox: Kill focus occurred")
						Case CBN_DROPDOWN : TextOut("Combobox: Drop down occurred")
						Case CBN_CLOSEUP : TextOut("Combobox: Close up occurred")
					End Select
				Case QueryObject(b1,1) ; Button command message
					TextOut("Button1 Command... minimizing to tray")
			End Select
		Case BLESS+1 ; WM_NOTIFY
			Bless_CopyMemory(Bless_NMHDR, Bless_EventData\lparam, 12)
			Select Bless_NMHDR\hwndFrom
				Case QueryObject(tv,1)
					Select Bless_NMHDR\code
						Case TVN_ITEMEXPANDED : TextOut("Treeview: Expanded or contracted node")
						Case NM_SETFOCUS : TextOut("Treeview: Set focus occurred")
						Case NM_KILLFOCUS : TextOut("Treeview: Kill focus occurred")
						Case NM_CUSTOMDRAW : TextOut("Treeview: CustomDraw")
						Case NM_DBLCLK : TextOut("Treeview: Double Click")
						Default : TextOut("Treeview: Unhandled code "+Bless_NMHDR\code)
					End Select
				Case QueryObject(lb,1)
					Select Bless_NMHDR\code
						Case LVN_ITEMCHANGED : TextOut("Listview: Item changed")
						Case LVN_ITEMACTIVATE : TextOut("Listview: Item activated")
						Case NM_CLICK : TextOut("Listview: Item clicked")
						Case NM_RCLICK : TextOut("Listview: Item right-clicked")
						Case NM_DBLCLK : TextOut("Listview: Item double-clicked")
						Case NM_CUSTOMDRAW : TextOut("Listview: CustomDraw")
						Case NM_KILLFOCUS : TextOut("Listview: Kill focus occurred")
						Default : TextOut("Listview: Unhandled code " + Bless_NMHDR\code)
					End Select
			End Select
		Case BLESS+2 ; WM_CUT
			TextOut("You just CUT something to the clipboard")
		Case BLESS+3 ; WM_COPY
			TextOut("You just COPIED something to the clipboard")
		Case BLESS+4 ; WM_PASTE
			TextOut("You just PASTED something from the clipboard")
		Case BLESS+5 ; WM_LBUTTONDOWN
			TextOut("LMB @ "+"("+(Bless_EventData\lparam And $FFFF)+","+(Bless_EventData\lparam Shr 16)+")")
		Case BLESS+6 ; WM_RBUTTONDOWN
			TextOut("RMB @ "+"("+(Bless_EventData\lparam And $FFFF)+","+(Bless_EventData\lparam Shr 16)+")")
		Case BLESS+7 ; WM_DROPFILES
			fname$=String(" ", 256)
			Bless_DragQueryFile(Bless_EventData\wparam, 0, fname, Len(fname))
			Bless_DragFinish(Bless_EventData\wparam)
			TextOut(fname)
		Case BLESS+8 ; WM_USER (for systray notification icon)
			systray$ = ""
			Select Bless_EventData\lparam
				Case WM_MOUSEMOVE : systray = "Mouse Move"
				Case WM_LBUTTONDOWN : systray = "Left Button Down"
				Case WM_LBUTTONUP : systray = "Left Button Up"
				Case WM_LBUTTONDBLCLK
					systray = "Left Button Double Click"
					; Restore window
					Bless_GetWindowPlacement(hwnd, Bless_WP)
					Bless_WP\showcmd = 9
					Bless_SetWindowPlacement(hwnd, Bless_WP)
					; Remove tray icon
					Shell_NotifyIcon(2, nid)
				Case WM_RBUTTONDOWN : systray = "Right Button Down"
				Case WM_RBUTTONUP : systray = "Right Button Up"
				Case WM_RBUTTONDBLCLK : systray = "Right Button Double Click"
				Case WM_MBUTTONDOWN : systray = "Middle Button Down"
				Case WM_MBUTTONUP : systray = "Middle Button Up"
				Case WM_MBUTTONDBLCLK : systray = "Middle Button Double Click"
			End Select
			TextOut("Systray: " + systray)
		Case BLESS+9 ; WM_DRAWITEM (for custom button, normal state)
			TextOut("Button 2: Redrawing...")
			Bless_CopyMemory(Bless_DrawItem, Bless_EventData\lparam, 48)
			If Bless_DrawItem\itemState
				DrawCustomButton(1) ; Pressed
			Else
				DrawCustomButton() ; Not Pressed
			EndIf
		Case BLESS+40 ; WM_DESTROY (notepad)
			EnableGadget(b3)
			Bless_UnregisterEvent(BLESS+40)
			Bless_UnregisterEvent(BLESS+41)
			TextOut("Notepad Demo END")
		Case BLESS+41 ; WM_CHAR (in notepad)
			AddTextAreaText(tar, Chr$(Bless_EventData\wparam))
		Case BLESS+50 ; WM_MOUSEMOVE (on window)
			TextOut("Mousemove (window) @ "+"("+(Bless_EventData\lparam And $FFFF)+","+(Bless_EventData\lparam Shr 16)+")")
		Case BLESS+51 ; WM_MOUSEMOVE (on textarea)
			TextOut("Mousemove (textarea) @ "+"("+(Bless_EventData\lparam And $FFFF)+","+(Bless_EventData\lparam Shr 16)+")")
		Default
			TextOut("BLESS: Unhandled event BLESS+"+(EventData()-BLESS))
	End Select
End Function

Function NotepadDemo()
	TextOut("Notepad Demo:"+Chr$(10))
	DisableGadget(b3)
	; Get window handles
	notepad = Bless_FindWindowEx(0, 0, "Notepad", "Untitled - Notepad")
	notepadedit = Bless_FindWindowEx(notepad, 0, "Edit", "")
	; Send text to notepad
	notepadstring$ = "Start typing here, then look at the BLESS window..."+Chr$(10)
	notepadstring=notepadstring+"Close Notepad to reactivate the Notepad Demo button."+Chr$(10)
	notepadstring=notepadstring+"----------------------------"+Chr$(10)
	For i = 1 To Len(notepadstring)
		Bless_SendMessage(notepadedit, $102, Asc(Mid$(notepadstring, i, 1)), 0)
		Delay 30
	Next
	Bless_SendMessage(notepadedit, $102, 10, 0)
	; Register BLESS events
	Bless_RegisterEvent(BLESS+40, WM_DESTROY, notepad, hwnd)
	Bless_RegisterEvent(BLESS+41, WM_CHAR, notepadedit, hwnd)
End Function

Function DrawCustomButton(pressed% = 0)
	dc% = Bless_GetDC(QueryObject(b2,1))
	penb% = Bless_CreatePen(0, 2, $ff0000)
	peng% = Bless_CreatePen(0, 2, $00ff00)
	penr% = Bless_CreatePen(0, 2, $0000ff)
	If pressed Then
		Bless_SelectObject(dc, peng)
		Bless_Rectangle(dc, 0, 0, 100, 55)
		Bless_SelectObject(dc, penr)
		Bless_Rectangle(dc, 3, 3, 97, 52)
		Bless_SelectObject(dc, penb)
		Bless_Rectangle(dc, 6, 6, 94, 49)
		Bless_TextOut(dc, 18, 11, "Custom", 6)
		Bless_TextOut(dc, 36, 29, "Button", 6)
	Else
		Bless_SelectObject(dc, penb)
		Bless_Rectangle(dc, 0, 0, 100, 55)
		Bless_SelectObject(dc, peng)
		Bless_Rectangle(dc, 3, 3, 97, 52)
		Bless_SelectObject(dc, penr)
		Bless_Rectangle(dc, 6, 6, 94, 49)
		Bless_TextOut(dc, 17, 10, "Custom", 6)
		Bless_TextOut(dc, 35, 28, "Button", 6)
	EndIf
	Bless_DeleteObject(penb)
	Bless_DeleteObject(peng)
	Bless_DeleteObject(penr)
	Bless_ReleaseDC(QueryObject(b2,1), dc)
End Function

Function TextOut(s$)
	AddTextAreaText(tar, Chr$(10)+s$)
End Function

Function InitGui()
	; window gadgets
	w=CreateWindow("BLESS Example",100,200,500,205,0,35)
	lbl=CreateLabel("BLESS (BLitz EventS System) beta, by Chad Dylan Long. "+Chr$(169)+" 2004 Minty Software, LLC. (www.mintysoftware.com)", 5, 2, 490, 15, w, 3)
	cb=CreateComboBox(5,20,100,20,w)
	tv=CreateTreeView(5,45,100,75,w)
	eb=CreateTextField(5,150,205,20,w)
	CreateLabel("Try dragging and dropping a file onto me, or just click around on the window", 5, 173, 200, 30, w)
	lb=CreateListBox(110,20, 100, 40, w,1)
	b1=CreateButton("Minimize to Tray", 110, 65, 100, 20, w)
	b2=CreateButton("Custom Button", 110, 90, 100, 55, w)
	b3=CreateButton("Notepad Demo", 5, 125, 100, 20, w)
	chk1=CreateButton("Monitor WM_MOUSEMOVE on window", 240, 173, 210, 15, w, 2)
	chk2=CreateButton("Monitor WM_MOUSEMOVE on textarea", 240, 188, 210, 15, w, 2)
	tar=CreateTextArea(215, 20, 280, 150, w)
	fntArial=LoadFont("Arial", 12)
	SetGadgetFont(lbl, fntArial)
	AddGadgetItem(cb, "combobox", True)
	AddGadgetItem(cb,"item1")
	AddGadgetItem(cb,"item2")
	tvn1=AddTreeViewNode("root",TreeViewRoot(tv))
	tvn2=AddTreeViewNode("Node1", tvn1)
	AddTreeViewNode("Node3", tvn2)
	AddTreeViewNode("D-Click", TreeViewRoot(tv))
	SetGadgetText(eb, "Cut, Copy, and Paste in me")
	AddGadgetItem(lb,"click")
	AddGadgetItem(lb,"listview")
	SetTextAreaText(tar, "BLESS EVENTS OUTPUT WINDOW"+Chr$(10)+String("-",80)+Chr$(10))

	; custom button - make OwnerDrawn (Button style 11)
	Bless_SendMessage(QueryObject(b2,1), $F4, 11, True)
	
	; main window handle
	hwnd = QueryObject(w,1)

	; notification area icon
	nid = CreateBank(88)
	PokeInt(nid, 0, BankSize(nid))
	PokeInt(nid, 4, QueryObject(w,1))
	PokeInt(nid, 8, 1)
	PokeInt(nid, 12, 7)
	PokeInt(nid, 16, WM_USER)
	PokeInt(nid, 20, Bless_ExtractIcon(QueryObject(w,1), SystemProperty("systemdir")+"shell32.dll", 21))
	szTip$ = "I'm BLESSED! (Double click to restore window)"
	For i = 0 To Len(szTip)-1
		PokeByte(nid, i+24, Asc(Mid(szTip, i+1, 1)))
	Next
End Function
